% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/MxInterval.R
\name{omxParallelCI}
\alias{omxParallelCI}
\title{omxParallelCI}
\usage{
omxParallelCI(model, run = TRUE)
}
\arguments{
\item{model}{an MxModel with confidence intervals in it}

\item{run}{whether to run the model or just return the parallelized interval models}
}
\value{
an MxModel object
}
\description{
Create parallel models for parallel confidence intervals
}
\examples{
require(OpenMx)
data(demoOneFactor)
manifests <- names(demoOneFactor)
latents <- c("G")
factorModel <- mxModel("One Factor",
                      type="RAM",
                      manifestVars=manifests,
                      latentVars=latents,
                      mxPath(from=latents, to=manifests),
                      mxPath(from=manifests, arrows=2),
                      mxPath(from=latents, arrows=2, free=FALSE, values=1.0),
                      mxData(observed=cov(demoOneFactor), type="cov",
                      numObs=500),
     # add confidence intervals for free params in A and S matrices
                      mxCI(c('A', 'S')))
factorRun <- mxRun(factorModel)
factorCI <- omxParallelCI(factorRun) # Run CIs in parallel
}

