% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/global.R
\name{certificate_df}
\alias{certificate_df}
\title{Generate a data frame with certificate information}
\usage{
certificate_df(x, time = Sys.time())
}
\arguments{
\item{x}{A list containing `data_formatted` and `rules` elements.}

\item{time}{the time the certificate is generated, can be passed a value or uses current system time.}
}
\value{
A data frame with certificate information.
}
\description{
This function creates a data frame with certificate information including the current time,
data and rule hashes, package version, and web hash.
}
\examples{
\donttest{
certificate_df(x = list(data_formatted = data.frame(a = 1:3, b = 4:6),
                        rules = validate::validator(a > 0, b > 0)),
               time = Sys.time())
}
}