% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addTests}
\alias{addTests}
\title{Add tests}
\usage{
addTests(study, tests, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{tests}{The tests from the study. The input object is a list of lists.
Each element of the top-level list is a model. The names should be the
modelIDs. For each modelID, each element of the nested list is a test. The
names should be the testIDs. The value should be a single character string
describing the testID. To share tests across multiple models, use the
modelID "default". Instead of a single character string, you can provide a
list of metadata fields about each test. The field "description" will be
used to derive the tooltip displayed in the app.}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
\code{study}, but modified to include the newly added data
}
\description{
Add tests
}
\examples{
  study <- createStudy("example")
  tests <- list(
    default = list(
      test_01 = "Name of first test",
      test_02 = "Name of second test"
    )
  )
  study <- addTests(study, tests)

  # Alternative: provide additional metadata about each test
  tests <- list(
    default = list(
      test_01 = list(
        description = "Name of first test",
        comparison_type = "treatment vs control",
        effect_size = "beta"
      ),
      test_02 = list(
        description = "Name of second test",
        comparison_type = "treatment vs control",
        effect_size = "logFC"
      )
    )
  )

}
