% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add.R
\name{addPlots}
\alias{addPlots}
\title{Add custom plotting functions}
\usage{
addPlots(study, plots, reset = FALSE)
}
\arguments{
\item{study}{An OmicNavigator study created with \code{\link{createStudy}}}

\item{plots}{Custom plotting functions for the study. The input object is a
nested list. The first list corresponds to the modelID(s). The second list
corresponds to the name(s) of the function(s) defined in the current R
session. The third list provides metadata to describe each plot. The only
required metadata element is \code{displayName}, which controls how the
plot will be named in the app. You are encouraged to also specify the
\code{plotType}, e.g. \code{"singleFeature"}, \code{"multiFeature"},
\code{"multiTest"}, \code{"multiModel"}. PlotType accepts vector of
entries, whenever applicable, e.g., plotType = c(\code{"multiFeature"},
\code{"multiTest"}). If you do not specify the \code{plotType}, the plot
will be assumed to be \code{"singleFeature"} and \code{"singleTest"}.
Optionally, if the plotting function requires external packages, these can
be defined in the element \code{packages}. To share plots across multiple
models, use the modelID "default". To add a plotting function that returns
an interactive plotly plot, add "plotly" to the \code{plotType} vector.}

\item{reset}{Reset the data prior to adding the new data (default:
\code{FALSE}). The default is to add to or modify any previously added data
(if it exists). Setting \code{reset = TRUE} enables you to remove existing
data you no longer want to include in the study.}
}
\value{
Returns the original \code{onStudy} object passed to the argument
  \code{study}, but modified to include the newly added data
}
\description{
Include custom plots that the app will display when a feature is selected by
the user.
}
\details{
Custom plotting functions are passed a list of data frames: \code{assays}
with the measurements, \code{features} with the feature data,
\code{samples} with the sample data, and \code{results} with test results
data. Note that \code{assays}, \code{features} and \code{results}
only include data for the specified featureID(s) (and
re-ordered so their rows match). Thus your custom plotting function must have
at least one argument. It can have additional arguments if you wish, but
these must be provided with default values, because \code{plotStudy} only
passes the plotting data to the first argument.

Note that any ggplot2 plots will require extra care. This is because the
plotting code will be inserted into a study package, and thus must follow the
\href{https://ggplot2.tidyverse.org/articles/ggplot2-in-packages.html#using-aes-and-vars-in-a-package-function-1}{best
practices for using ggplot2 within packages}. Specifically, when you refer to
columns of the data frame, e.g. \code{aes(x = group)}, you need to prefix it
with \code{.data$}, so that it becomes \code{aes(x = .data$group)}.
Fortunately this latter code will also run fine as you interactively develop
the function.
}
\seealso{
\code{\link{getPlottingData}}, \code{\link{plotStudy}}
}
