## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----message=FALSE, warning=FALSE---------------------------------------------
library(OmicInt)

## -----------------------------------------------------------------------------
#data<-score_genes("data.csv")
#head(data)

#   Symbol log2FoldChange       pvalue Interactors Association_score
#1   SAR1A      -2.187773 2.656521e-05          24         0.0000000
#2 C6orf62      -2.674213 1.691567e-07           0         0.0000000
#3     AXL      -2.786508 1.739595e-04           2         0.3230769
#4   BICC1      -3.598553 2.738887e-04           3         0.3000000
#5  CAPZA1      -1.732784 2.321835e-04          66         0.3789474
#6   TXNIP       1.460629 7.347205e-05          30         0.3000000
#  Specificity_score  LFCscore
#1             0.000 -2.187773
#2             0.000 -2.674213
#3             0.590 -3.686764
#4             0.751 -4.678119
#5             0.601 -2.389418
#6             0.631  1.898818

## -----------------------------------------------------------------------------
#density_plot(data)

## -----------------------------------------------------------------------------
#feature_distribution(data)

## -----------------------------------------------------------------------------
#plot_3D_distribution(data)

## -----------------------------------------------------------------------------
#class_summary(data)

## -----------------------------------------------------------------------------
#location_summary(data)

## -----------------------------------------------------------------------------
#location_map(data)

## -----------------------------------------------------------------------------
#class_map(data)

## -----------------------------------------------------------------------------
#HK_genes(data)

## -----------------------------------------------------------------------------
#model_report<-cluster_genes(data)

## -----------------------------------------------------------------------------
#head(model_report)

## -----------------------------------------------------------------------------
#Best BIC values:
#             VVI,6        VVI,7        VVI,5
#BIC      -2481.986 -2483.544400 -2485.429861
#BIC diff     0.000    -1.558131    -3.443592

## -----------------------------------------------------------------------------
#       Interactors  LFCscore Cluster Symbol
#CAPZA1          66 -2.389418       1 CAPZA1
#RAB31            0 -2.542398       2  RAB31
#UBE2B            2 -2.061383       2  UBE2B
#YWHAG           21 -2.111448       1  YWHAG
#ENAH            29 -2.207514       1   ENAH
#PPP3CA          51 -3.500322       1 PPP3CA

## -----------------------------------------------------------------------------
# "Condition subclasses"
#
#[1] "CKD"          "healthy"      "hypertension"
#
#pattern_search(data, meta)
#
#    
#               Gene count
#down_down_down          0
#down_down_up         2679
#down_up_down          670
#down_up_up           1076
#up_down_down         5503
#up_down_up           2550
#up_up_down           2856
#up_up_up              361

## -----------------------------------------------------------------------------
#$up_up_down
#   [1] "A4GALT"        "AASDHPPT"      "AATF"         
#   [4] "ABCC11"        "ABCC9"         "ABCG2"        
#   [7] "ABHD13"        "ABHD2"         "ABI3"         
#  [10] "ABI3BP"        "ABITRAM"       "ABO"   

## -----------------------------------------------------------------------------
#cluster_heatmap(data)

## -----------------------------------------------------------------------------
#interactor_map(data)

## -----------------------------------------------------------------------------
#cpg_genes<-CpG_summary(data)
#head(cpg_genes)

## -----------------------------------------------------------------------------
#   Symbol log2FoldChange       pvalue Association_score
#1   SAR1A      -2.187773 2.656521e-05         0.0000000
#2 C6orf62      -2.674213 1.691567e-07         0.0000000
#3     AXL      -2.786508 1.739595e-04         0.3230769
#4   BICC1      -3.598553 2.738887e-04         0.3000000
#5  CAPZA1      -1.732784 2.321835e-04         0.3789474
#6   TXNIP       1.460629 7.347205e-05         0.3000000
#  Specificity_score  LFCscore                  CpG GC_content
#1             0.000 -2.187773 chr1:1211340:1214153      70.33
#2             0.000 -2.674213                   NA         NA
#3             0.590 -3.686764 chr1:1471765:1497848      58.83
#4             0.751 -4.678119                   NA         NA
#5             0.601 -2.389418                   NA         NA
#6             0.631  1.898818                   NA         NA
#               Class
#1           Receptor
#2                 NA
#3         Pseudogene
#4             Enzyme
#5             Enzyme
#6 Regulatory protein

## -----------------------------------------------------------------------------
#df<-miRNA_summary_validated(data)
#head(df)

## -----------------------------------------------------------------------------
#df<-miRNA_summary_predicted(data)

## -----------------------------------------------------------------------------
#df<-miRNA_network(c("PIP4K2A","MOB1A","PHACTR2","MDM2","YWHAG" ,"RAB31"  ))
#head(df)

