% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_normalization_utils.R
\name{olink_norm_input_class}
\alias{olink_norm_input_class}
\title{Check classes of input in olink_normalization function}
\usage{
olink_norm_input_class(
  df1,
  df2,
  overlapping_samples_df1,
  overlapping_samples_df2,
  df1_project_nr,
  df2_project_nr,
  reference_project,
  reference_medians,
  norm_mode
)
}
\arguments{
\item{df1}{First dataset to be used in normalization (required).}

\item{df2}{Second dataset to be used in normalization.}

\item{overlapping_samples_df1}{Samples to be used for adjustment factor
calculation in df1 (required).}

\item{overlapping_samples_df2}{Samples to be used for adjustment factor
calculation in df2.}

\item{df1_project_nr}{Project name of first dataset (df1).}

\item{df2_project_nr}{Project name of first dataset (df2).}

\item{reference_project}{Project name of reference_project. Should be one of
\var{df1_project_nr} or \var{df2_project_nr}. Indicates the project to which
the other project is adjusted to.}

\item{reference_medians}{Dataset with columns "OlinkID" and "Reference_NPX".
Used for reference median normalization.}

\item{norm_mode}{Scalar character from \var{olink_norm_modes} with the
normalization to be performed. Output from
\code{\link{olink_norm_input_validate}}.}
}
\value{
\code{NULL} unless there is an error
}
\description{
Check if \var{df1}, \var{df2} and/or \var{reference_medians} are tibble or
ArrowDataset datasets; if \var{overlapping_samples_df1} and/or
\var{overlapping_samples_df2} are character vectors; and if
\var{df1_project_nr}, \var{df2_project_nr} and/or \var{reference_project} are
scalar character vectors.
}
\author{
Klev Diamanti
}
