% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/olink_bridgeability_plot.R
\name{olink_bridgeability_plot}
\alias{olink_bridgeability_plot}
\title{Plots for each bridgeable assays between two platforms / products
Author : Amrita Kar}
\usage{
olink_bridgeability_plot(data, median_counts_threshold = 150, min_count = 10)
}
\arguments{
\item{data}{data frame of cross-product bridge normalized data generated by
olink_normalization()}

\item{median_counts_threshold}{Numeric value to use for median counts
threshold for the two platforms. Default is 150}

\item{min_count}{Numeric value to use for minimum counts
for the two platforms. Default is 10}
}
\value{
An object of class "ggplot", 4 combined plots for each protein.
}
\description{
Generates a combined plot per assay containing a violin and boxplot plot
for IQR ranges ;
correlation plot of NPX values ;
a median count bar plot and
KS plots from 2 platforms
}
\examples{
\donttest{

npx_ht <- OlinkAnalyze:::data_ht_small |>
 dplyr::filter(SampleType == "SAMPLE") |>
 dplyr::mutate(Project = "data1")

npx_3072 <- OlinkAnalyze:::data_3k_small |>
 dplyr::filter(SampleType == "SAMPLE") |>
 dplyr::mutate(Project = "data2")

overlapping_samples <- unique(intersect(npx_ht |>
                                         dplyr::distinct(SampleID) |>
                                         dplyr::pull(),
                                       npx_3072 |>
                                         dplyr::distinct(SampleID) |>
                                         dplyr::pull()))

data <- OlinkAnalyze::olink_normalization(df1 = npx_ht,
                                         df2 = npx_3072,
                                         overlapping_samples_df1 =
                                           overlapping_samples,
                                         df1_project_nr = "Explore HT",
                                         df2_project_nr = "Explore 3072",
                                         reference_project = "Explore HT")

olinkids <- unique(paste0(data$OlinkID,"_",data$Assay))
results <- olink_bridgeability_plot(data = data,
                          median_counts_threshold = 150,
                          min_count = 10)
names(results) <- olinkids
}
}
