/*
 * Decompiled with CFR 0.152.
 */
package org.andwellness.xml.datagenerator.generator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.andwellness.xml.datagenerator.generator.JSONGeneratorType;
import org.andwellness.xml.datagenerator.model.ChoiceCustom;
import org.andwellness.xml.datagenerator.model.DataPoint;
import org.andwellness.xml.datagenerator.model.RepeatableSet;
import org.andwellness.xml.datagenerator.model.Response;
import org.andwellness.xml.datagenerator.model.Survey;
import org.andwellness.xml.datagenerator.utility.JSONUtility;
import org.andwellness.xml.datagenerator.utility.ValueCreator;
import org.apache.log4j.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class DownloadJSONGeneratorType
extends JSONGeneratorType {
    private Survey _survey;
    private static Logger _logger = Logger.getLogger(DownloadJSONGeneratorType.class);

    @Override
    public Object translateSurveysToJson(List<Survey> surveyList) {
        JSONArray finalJSONArray = new JSONArray();
        for (Survey survey : surveyList) {
            JSONArray surveyJSONArray = this.translateSurveyToJsonArray(survey);
            JSONUtility.appendJSONArray(finalJSONArray, surveyJSONArray);
        }
        JSONObject topLevelJson = new JSONObject();
        try {
            topLevelJson.put("data", finalJSONArray);
            topLevelJson.put("result", "success");
        }
        catch (JSONException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        return topLevelJson;
    }

    @Override
    public JSONArray translateSurveyToJsonArray(Survey survey) {
        this._survey = survey;
        JSONArray translatedJSON = new JSONArray();
        Map<String, Object> surveyMetadata = this.findMetadata(survey.getCurrentDataPoints(), ValueCreator.date(survey.getCreationTime()));
        List<Response> responseList = survey.getResponseList();
        for (Response response : responseList) {
            if (response instanceof DataPoint) {
                DataPoint dataPoint = (DataPoint)response;
                if (dataPoint.isMetadata() || dataPoint.isNotDisplayed()) continue;
                try {
                    JSONArray generatedDataPointJSON = this.generateDataPoint(dataPoint, surveyMetadata);
                    JSONUtility.appendJSONArray(translatedJSON, generatedDataPointJSON);
                }
                catch (IllegalArgumentException e) {
                    _logger.warn(e.getMessage());
                }
                continue;
            }
            if (!(response instanceof RepeatableSet)) continue;
            RepeatableSet repeatableSet = (RepeatableSet)response;
            Iterator<List<DataPoint>> repeatableSetIterator = repeatableSet.getRepeatableSetListIterator();
            while (repeatableSetIterator.hasNext()) {
                List<DataPoint> repeatableSetDataPointList = repeatableSetIterator.next();
                Map<String, Object> repeatableSetMetadata = this.findMetadata(repeatableSetDataPointList, (String)surveyMetadata.get("datetime"));
                for (DataPoint dataPoint : repeatableSetDataPointList) {
                    if (dataPoint.isMetadata() || dataPoint.isNotDisplayed()) continue;
                    try {
                        JSONArray generatedDataPointJSON = this.generateDataPoint(dataPoint, repeatableSetMetadata);
                        JSONUtility.appendJSONArray(translatedJSON, generatedDataPointJSON);
                    }
                    catch (IllegalArgumentException e) {
                        _logger.warn(e.getMessage());
                    }
                }
            }
        }
        return translatedJSON;
    }

    private JSONArray generateDataPoint(DataPoint dataPoint, Map<String, Object> surveyMetadata) {
        JSONArray translatedDataPointJSON = new JSONArray();
        String label = dataPoint.getId();
        String displayType = dataPoint.getDisplayType().toString();
        List<Object> valueList = this.translateValue(dataPoint);
        for (Object value2 : valueList) {
            HashMap<String, Object> jsonHash = new HashMap<String, Object>();
            jsonHash.put("label", label);
            jsonHash.put("value", value2);
            jsonHash.put("tz", this._survey.getTz());
            jsonHash.put("latitude", this._survey.getLat());
            jsonHash.put("longitude", this._survey.getLon());
            jsonHash.put("type", displayType);
            jsonHash.put("timestamp", surveyMetadata.get("datetime"));
            translatedDataPointJSON.put(jsonHash);
        }
        return translatedDataPointJSON;
    }

    private List<Object> translateValue(DataPoint dataPoint) {
        List<Object> translatedValues;
        if (dataPoint.isSkipped()) {
            List<Object> translatedValues2 = this.translateSkipped();
            return translatedValues2;
        }
        if (_logger.isDebugEnabled()) {
            _logger.debug("Translating datapoint with id " + dataPoint.getId() + " and value " + dataPoint.getValue());
        }
        switch (dataPoint.getPromptType()) {
            case timestamp: {
                translatedValues = this.translateTimestamp((String)dataPoint.getValue());
                break;
            }
            case number: {
                translatedValues = this.translateNumber((Integer)dataPoint.getValue());
                break;
            }
            case hours_before_now: {
                translatedValues = this.translateHoursBeforeNow((Integer)dataPoint.getValue());
                break;
            }
            case text: {
                translatedValues = this.translateText((String)dataPoint.getValue());
                break;
            }
            case multi_choice: {
                List choices = (List)dataPoint.getValue();
                translatedValues = this.translateMultiChoice(choices);
                break;
            }
            case single_choice: {
                translatedValues = this.translateSingleChoice((Integer)dataPoint.getValue());
                break;
            }
            case single_choice_custom: {
                translatedValues = this.translateSingleChoiceCustom((ChoiceCustom)dataPoint.getValue());
                break;
            }
            case multi_choice_custom: {
                translatedValues = this.translateMultiChoiceCustom((ChoiceCustom)dataPoint.getValue());
                break;
            }
            case photo: {
                translatedValues = this.translatePhoto((String)dataPoint.getValue());
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown prompt type " + dataPoint.getPromptType().toString());
            }
        }
        return translatedValues;
    }

    private Map<String, Object> findMetadata(List<DataPoint> dataPoints, String metadataTime) {
        HashMap<String, Object> newMetadata = new HashMap<String, Object>();
        newMetadata.put("datetime", metadataTime);
        for (DataPoint dataPoint : dataPoints) {
            if (!dataPoint.isMetadata() || dataPoint.isNotDisplayed()) continue;
            DataPoint.PromptType dataPointPromptType = dataPoint.getPromptType();
            if (_logger.isDebugEnabled()) {
                _logger.debug("Found a datapoint of type metadata with id " + dataPoint.getId() + " and value " + dataPoint.getValue());
            }
            switch (dataPointPromptType) {
                case timestamp: {
                    newMetadata.put("datetime", this.translateTimestamp((String)dataPoint.getValue()).get(0));
                    break;
                }
                case hours_before_now: {
                    newMetadata.put("datetime", this.translateHoursBeforeNow((Integer)dataPoint.getValue()).get(0));
                }
            }
        }
        return newMetadata;
    }

    public List<Object> translateTimestamp(String timestamp) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add(timestamp);
        return translatedValues;
    }

    public List<Object> translateNumber(Integer number) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add(number.toString());
        return translatedValues;
    }

    public List<Object> translateHoursBeforeNow(Integer number) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        String timestamp = ValueCreator.hours_before_date(this._survey.getCreationTime(), number);
        translatedValues.add(timestamp);
        return translatedValues;
    }

    public List<Object> translateText(String text) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add(text);
        return translatedValues;
    }

    public List<Object> translateMultiChoice(List<Integer> choiceList) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        Iterator<Integer> choiceListIterator = choiceList.iterator();
        while (choiceListIterator.hasNext()) {
            translatedValues.add(choiceListIterator.next().toString());
        }
        return translatedValues;
    }

    public List<Object> translateSingleChoice(Integer choice) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add(choice.toString());
        return translatedValues;
    }

    public List<Object> translateSingleChoiceCustom(ChoiceCustom choice) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        return translatedValues;
    }

    public List<Object> translateMultiChoiceCustom(ChoiceCustom choiceList) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        return translatedValues;
    }

    public List<Object> translatePhoto(String uuid) {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add(uuid);
        return translatedValues;
    }

    public List<Object> translateNotDisplayed() {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add("NOT_DISPLAYED");
        return translatedValues;
    }

    public List<Object> translateSkipped() {
        ArrayList<Object> translatedValues = new ArrayList<Object>();
        translatedValues.add("SKIPPED");
        return translatedValues;
    }
}

