% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Coeff.R
\name{coeff}
\alias{coeff}
\title{Performs the modeling of the observed 
data and returns the coefficients}
\usage{
coeff(data, model, startA, startB, startC, startD, startG)
}
\arguments{
\item{data}{Data frame to be analyzed. The data frame must be in the following order:
\itemize{
\item \strong{First}: All columns containing the independent 
variable (e.g. \emph{time in hours})
\item \strong{Second}: All columns containing dependent variables
 (e.g. \emph{CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} 
 g L\ifelse{html}{\out{<sup>-1</sup>}}{\eqn{^{-1}}}
 production})
\item \strong{Header}: Columns must contain a 
header. If the treatment \strong{ID} is in 
the header, this \strong{ID} will be used 
to \strong{identify} the coefficients for each 
analyzed curve.}}

\item{model}{Model to be adjusted. Argument for model:
\itemize{
\item \strong{Model = 1}. 5PL Model (five-parameter logistic (5PL) model)
\item \strong{Model = 2}. Gompertz Model
\item \strong{Model = 3}. 4PL Model (four-parameter logistic (4PL) model)
}}

\item{startA}{Starting estimate of the value of A for model.}

\item{startB}{Starting estimate of the value of B for model.}

\item{startC}{Starting estimate of the value of C for model.}

\item{startD}{Starting estimate of the value of D for model.}

\item{startG}{Starting estimate of the value of G for model.}
}
\value{
The coefficients of the analyzed model 
are returned in a data.frame.

According to the model adopted, 
the following coefficients are presented:

5PL: \strong{a}, \strong{b}, \strong{c}, \strong{d} and \strong{g}.

Gompertz: \strong{a}, \strong{b}, and \strong{c}.

4PL: \strong{a}, \strong{b}, \strong{c} and \strong{d}.
}
\description{
A function that, based on the 
observed data, the independent variable 
(e.g. time in h) and the dependent
 variable (e.g. CO\ifelse{html}{\out{<sub>2</sub>}}{\eqn{_2}} 
 production in g L\ifelse{html}{\out{<sup>-1</sup>}}{\eqn{^{-1}}}),
  performs the modeling of the fermentation 
  curve based on the chosen model (\strong{5PL}, \strong{Gompertz}, or \strong{4PL}). 
  
  As a result, the curve-fitted coefficients of 
  the chosen equation (model) are returned 
  in the form of data frame.
}
\details{
Curve fitting from the observed data is 
performed by the nlsLM() function in 
the 'minpack.lm' package.
}
\examples{

#Creating a data.frame. 
#First, columns containing independent variable.
#Second, columns containing dependent variable.
#The data frame created presents two 
#fermentation curves for two yeasts with 
#different times and carbon dioxide production.

df <- data.frame('Time_Yeast_A' = seq(0,280, by=6.23),
                 'Time_Yeast_B' = seq(0,170, by=3.7777778),
                 'CO2_Production_Yeast_A' = c(0,0.97,4.04,9.62,13.44,17.50,
                                              24.03,27.46,33.75,36.40,40.80,
                                             44.24,48.01,50.85,54.85,57.51,
                                             61.73,65.43,66.50,72.41,75.47,
                                             77.22,78.49,79.26,80.31,81.04,
                                             81.89,82.28,82.56,83.13,83.62,
                                             84.11,84.47,85.02,85.31,85.61,
                                             86.05,86.27,85.29,86.81,86.94,
                                             87.13,87.33,87.45,87.85),
                 'CO2_Production_Yeast_B' = c(0,0.41,0.70,3.05,15.61,18.41,
                                              21.37,23.23,28.28,41.28,43.98,
                                              49.54,54.43,60.40,63.75,69.29,
                                              76.54,78.38,80.91,83.72,84.66,
                                              85.39,85.81,86.92,87.38,87.61,
                                              88.38,88.57,88.72,88.82,89.22,
                                              89.32,89.52,89.71,89.92,90.11,
                                              90.31,90.50,90.70,90.90,91.09,
                                              91.29,91.49,91.68,91.88))

#Using the coeff() function to return the fitted model coefficients

coeff(data = df,
model = 1,
startA = 0,
startB = 1.5,
startC = 500,
startD = 92, 
startG = 1500) #5PL Model adopted

coeff(data = df,
model = 2, 
startA = 92,
startB = 1.5,
startC = 0,
startD = NA, 
startG = NA) #Gompertz Model adopted

coeff(data = df,
model = 3, 
startA = 0,
startB = 2.5,
startC = 10,
startD = 92, 
startG = NA) #4PL Model adopted


}
\author{
Angelo Gava
}
