% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/GeoFunctions.R
\name{distance}
\alias{distance}
\title{A function to compute the distance matrix between centroids
of spatial units}
\usage{
distance(spatobj = NULL, folder = NULL, shape = NULL)
}
\arguments{
\item{spatobj}{- a Spatial object (SpatialPolygonsDataFrame)}

\item{folder}{- a character vector with the folder (directory)
where the shapefile is}

\item{shape}{- a character vector with the name of the shapefile
(without the .shp extension)}
}
\value{
A matrix with the distance between spatial units centroids
}
\description{
The function is based on \pkg{rgdal} and \pkg{rgeos}
packages and it can be used by providing a  shape file or a R
spatial object (SpatialPolygonsDataFrame).
}
\examples{
distance(GreHSize)

foldername <- system.file('extdata', package = 'OasisR')
shapename <- 'GreHSize'
distance(folder = foldername, shape = shapename)
}
\seealso{
Other spatial functions used for segregation indices
computation: \code{\link{area}}, \code{\link{contig}},
\code{\link{perimeter}}, \code{\link{distcenter}},
\code{\link{boundaries}}, \code{\link{xgeo}}
}

