% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/SegFunctions.R
\name{JPielou}
\alias{JPielou}
\title{A function to compute Pielou normalised diversity index}
\usage{
JPielou(x)
}
\arguments{
\item{x}{- an object of class matrix (or that can be coerced
to that class), where each column represents the distribution
of a population group, within spatial units. The number of
columns should be greater than one (at least two population
groups are required).}
}
\value{
Normalised diversity index
}
\description{
Pielou index normalises Shannon-Wiener diversity
index (\code{\link{HShannon}}).
}
\examples{
x <- slot(GreHSize, 'data')[ ,3:5]
JPielou(x)
}
\references{
Pielou E. C. (1966) \emph{Shannon's formula as a
measure of species diversity: its use and misuse}. The
American Naturalist 100, 463-465
}
\seealso{
Other multigroup eveness indices:
\code{\link{HShannon}}, \code{\link{ISimpson}}, \code{\link{GiniMulti}},
\code{\link{DMulti}}

Other multigroup indices: \code{\link{PIsol}},
\code{\link{RelDivers}}
}

