% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otclust.R
\name{otclust}
\alias{otclust}
\title{Mean partition by optimal transport anlignment.}
\usage{
otclust(ensemble, idx = NULL)
}
\arguments{
\item{ensemble}{-- a matrix of ensemble partition. Use \code{ensemble()} to generate an ensemble of perturbed partitions.}

\item{idx}{-- an integer indicating the index of reference partition in \code{ensemble}. If not specified, median partition is used as the reference partition.}
}
\value{
a list of mean partition(meanpart), distance of mean partition to other partitions in ensemble(distance), weight matrix(weight), topological stability statistics(match), covering point set(cps), cluster alignment and point-based separability(cap).
}
\description{
This function calculates the mean partition of an ensemble of partitions by optimal transport alignment and uncertainty/stability measures.
}
\examples{
data(sim1)
# the number of clusters.
C = 4
ens.data = ensemble(sim1$X, nbs=8, clust_param=C, clustering="kmeans", perturb_method=1)
# find mean partition and uncertainty statistics.
ota = otclust(ens.data)
}
