% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/roxygen.R
\docType{data}
\name{telework_data}
\alias{telework_data}
\title{Telework data}
\format{
Data frame with numeric columns
\describe{
\item{id}{Respondent ID}
\item{weight}{Sample weight}
\item{vmd}{Weekly vehicle-miles traveled}
\item{vmd_ln}{Log-transformed VMD, the dependent variable of the outcome model}
\item{twing_status}{Teleworking status: 1=Non-TWer, 2=Non-usual TWer, 3=Usual TWer}
\item{female}{Sex: female}
\item{age_mean}{Mean-centered age}
\item{age_mean_sq}{Sqaure of mean-centered age}
\item{race_white}{Race: white only}
\item{race_black}{Race: black only}
\item{race_other}{Race: other}
\item{edu_1}{Education: high school or lower}
\item{edu_2}{Education: some college}
\item{edu_3}{Education: BA or higher}
\item{hhincome_1}{Household income: less than $50,000}
\item{hhincome_2}{Household income: $50,000 to $99,999}
\item{hhincome_3}{Household income: $100,000 or more}
\item{flex_work}{Flexible work schedule}
\item{work_fulltime}{Full-time worker}
\item{twing_feasibility}{Teleworking feasibility (days/month)}
\item{vehicle}{Number of household vehicles}
\item{child}{Number of children}
\item{urban}{Residential location: urban}
\item{suburban}{Residential location: suburban}
\item{smalltown}{Residential location: small town}
\item{rural}{Residential location: rural}
\item{att_prolargehouse}{Attitude: pro-large-house}
\item{att_proactivemode}{Attitude: pro-active-mode}
\item{att_procarowning}{Attitude: pro-car-owning}
\item{att_wif}{Attitude: work-interferes-with-family}
\item{att_proteamwork}{Attitude: pro-teamwork}
\item{att_tw_effective_teamwork}{Attitude: TW effective teamwork}
\item{att_tw_enthusiasm}{Attitude: TW enthusiasm}
\item{att_tw_location_flex}{Attitude: TW location flexibility}
\item{region_waa}{Region indicator: respondents from WAA MSA}
}
}
\usage{
telework_data
}
\description{
Telework data as used in \insertCite{Wang+Mokhtarian:2024;textual}{OPSR}.
}
\examples{
\donttest{

## model as in Xinyi & Mokhtarian (2024)
f <-
  ## ordinal and continuous outcome
  twing_status | vmd_ln ~
  ## selection model
  edu_2 + edu_3 + hhincome_2 + hhincome_3 +
  flex_work + work_fulltime + twing_feasibility +
  att_proactivemode + att_procarowning +
  att_wif + att_proteamwork +
  att_tw_effective_teamwork + att_tw_enthusiasm + att_tw_location_flex |
  ## outcome model NTW
  female + age_mean + age_mean_sq +
  race_black + race_other +
  vehicle + suburban + smalltown + rural +
  work_fulltime +
  att_prolargehouse + att_procarowning +
  region_waa |
  ## outcome model NUTW
  edu_2 + edu_3 + suburban + smalltown + rural +
  work_fulltime +
  att_prolargehouse + att_proactivemode + att_procarowning |
  ## outcome model UTW
  female + hhincome_2 + hhincome_3 +
  child + suburban + smalltown + rural +
  att_procarowning +
  region_waa

fit <- opsr(f, telework_data)
texreg::screenreg(fit, beside = TRUE, include.pseudoR2 = TRUE, include.R2 = TRUE)

}
}
\references{
\insertRef{Wang+Mokhtarian:2024}{OPSR}
}
\keyword{datasets}
