% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forecast_combinations.R
\name{forecast_combine}
\alias{forecast_combine}
\title{Forecast with forecast combinations}
\usage{
forecast_combine(
  Data,
  method = "unform",
  n.max = NULL,
  rolling.window = NA,
  trim = c(0.5, 0.95),
  burn.in = 1,
  parallel.dates = NULL
)
}
\arguments{
\item{Data}{data.frame: data frame of forecasted values to combine, assumes 'date' and 'observed' columns, but `observed' is not necessary for all methods}

\item{method}{string: the method to use; 'uniform', 'median', 'trimmed.mean', 'n.best', 'peLasso', 'lasso', 'ridge', 'elastic', 'RF', 'GBM', 'NN'}

\item{n.max}{int: maximum number of forecasts to select in n.best method}

\item{rolling.window}{int: size of rolling window to evaluate forecast error over, use entire period if NA}

\item{trim}{numeric: a two element vector with the winsorizing bounds for the trimmed mean method; c(min, max)}

\item{burn.in}{int: the number of periods to use in the first model estimation}

\item{parallel.dates}{int: the number of cores available for parallel estimation}
}
\value{
data.frame with a row for each combination method and forecasted date
}
\description{
A function to combine forecasts out-of-sample. Methods available include:
uniform weights, median forecast, trimmed (winsorized) mean, n-best,
ridge regression, lasso regression, elastic net, peLASSO,
random forest, tree-based gradient boosting machine, and single-layer neural network.
See package website for most up-to-date list of available models.
}
\examples{
\donttest{
 # simple time series
 A = c(1:100) + rnorm(100)
 B = c(1:100) + rnorm(100)
 C = c(1:100) + rnorm(100)
 date = seq.Date(from = as.Date('2000-01-01'), by = 'month', length.out = 100)
 Data = data.frame(date = date, A, B, C)

 # run forecast_univariate
 forecast.multi =
     forecast_multivariate(
       Data = Data,
       target = 'A',
       forecast.dates = tail(Data$date,5),
       method = c('ols','var'),
       horizon = 1,
       freq = 'month')
 # include observed valuesd
 forecasts =
   dplyr::left_join(
     forecast.multi,
     data.frame(date, observed = A),
     by = 'date'
   )

 # combine forecasts
 combinations =
   forecast_combine(
     forecasts,
     method = c('uniform','median','trimmed.mean',
                'n.best','lasso','peLasso'),
     burn.in = 5,
     n.max = 2)
}


}
