% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RotMat.R
\name{RotMatRF}
\alias{RotMatRF}
\title{Create a Projection Matrix: Random Forest (RF)}
\usage{
RotMatRF(dimX, numProj, catLabel = NULL, ...)
}
\arguments{
\item{dimX}{The number of dimensions.}

\item{numProj}{The number of projection directions (default ceiling(sqrt(\code{dimX}))).}

\item{catLabel}{A category labels of class \code{list} in predictors. (default NULL, for details see Examples of \code{\link{ODT}})}

\item{...}{Used to handle superfluous arguments passed in using paramList.}
}
\value{
A random matrix to use in running \code{\link{ODT}}.
\itemize{
\item{Variable: Variables to be projected.}
\item{Number: Number of projections.}
\item{Coefficient: Coefficients of the projection matrix.}
}
}
\description{
Create a projection matrix with coefficient 1 and 0 such that the ODRF (ODT) has the same partition variables as the Random Forest (CART).
}
\examples{
paramList <- list(dimX = 8, numProj = 3, catLabel = NULL)
set.seed(2)
(RotMat <- do.call(RotMatRF, paramList))

}
\seealso{
\code{\link{RotMatPPO}} \code{\link{RotMatRand}} \code{\link{RotMatMake}}
}
\keyword{rotation}
