% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sealing.R
\name{calc_sealing_risk}
\alias{calc_sealing_risk}
\title{Calculate soil sealing risk}
\usage{
calc_sealing_risk(A_SOM_LOI, A_CLAY_MI)
}
\arguments{
\item{A_SOM_LOI}{(numeric) The organic matter content of soil (\%)}

\item{A_CLAY_MI}{(numeric) The clay content of the soil (\%)}
}
\value{
The risk of soil sealing as affected by the soil organic matter and clay content. A numeric value.
}
\description{
This function calculates the risks of soil sealing.  This value can be evaluated by \code{\link{ind_sealing}}
}
\examples{
calc_sealing_risk(A_SOM_LOI = 3.5, A_CLAY_MI = 7.5)
calc_sealing_risk(A_SOM_LOI = c(3.5,6.5), A_CLAY_MI = c(7.5,15))

}
