% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CompareVolcanoPlots.r
\name{CompareVolcanoPlots}
\alias{CompareVolcanoPlots}
\title{Compare Volcano plots}
\usage{
CompareVolcanoPlots(lcoef, lpvals, normmeth = NULL, plimit = 0.05,
  coeflimit = 1, yrange = NULL, negcontrol = NULL, poscontrol = NULL,
  xlab = "Coefficients", ylab = "-log(p-value)", labelunderlim = FALSE,
  labelsig = FALSE, saveinteractiveplot = FALSE,
  interactiveplotname = "interactiveVolcanPlot", ...)
}
\arguments{
\item{lcoef}{A list of vectors of coefficients with metabolite names, each vector corresponding to a 
different noramlization method.}

\item{lpvals}{A list of vector of corresponding p-values.}

\item{normmeth}{A vector with the normalization method used corresponding in order to the 
data supplied to be displayed on the plot.}

\item{plimit}{A numeric indicating the p value cutoff. The default is set to
0.05.}

\item{coeflimit}{A numeric indicating the lower fold cutoff. The default is
set to 2.}

\item{yrange}{A numeric for the maximum y value (scale of y-axis is -log(p-value)), can only
be set to a value as big as the maximum y-value in the plots.}

\item{negcontrol}{A vector with the names of the metabolites used as negative controls,
to be coloured differently.}

\item{poscontrol}{A vector with the names of the metabolites used as positive controls,
to be coloured differently.}

\item{xlab}{\emph{x}-axis label.}

\item{ylab}{\emph{y}-axis label.}

\item{labelunderlim}{A logical indicating whether to label points that are not significant.}

\item{labelsig}{A logical indicating whether all significant points should be labeled.}

\item{saveinteractiveplot}{A logical indication whether the interactive plot produced should
be saved as a \code{.html} file.}

\item{interactiveplotname}{A character string indicating the name to be used for saving the
interactive plot.}

\item{...}{Arguments to VolcanoPlot function}
}
\description{
Produces a volcano plot that can be sued to compare between different normalisation methods.
}
\examples{
data("alldata_eg")
featuredata_eg<-alldata_eg$featuredata
dataview(featuredata_eg)
sampledata_eg<-alldata_eg$sampledata
dataview(sampledata_eg)
metabolitedata_eg<-alldata_eg$metabolitedata
dataview(metabolitedata_eg)

logdata <- LogTransform(featuredata_eg)
dataview(logdata$featuredata)
imp <-  MissingValues(logdata$featuredata,sampledata_eg,metabolitedata_eg,
                     feature.cutof=0.8, sample.cutoff=0.8, method="knn")
dataview(imp$featuredata)

#Linear model fit using unadjusted data
factormat<-model.matrix(~gender +Age +bmi, sampledata_eg)
unadjustedFit<-LinearModelFit(featuredata=imp$featuredata,
                             factormat=factormat,
                             ruv2=FALSE)
unadjustedFit

#Linear model fit using `is' normalized data 
Norm_is <-NormQcmets(imp$featuredata, method = "is", 
                    isvec = imp$featuredata[,which(metabolitedata_eg$IS ==1)[1]])
isFit<-LinearModelFit(featuredata=Norm_is$featuredata,
                     factormat=factormat,
                     ruv2=FALSE)
isFit

#Linear model fit with ruv-2 normalization
ruv2Fit<-LinearModelFit(featuredata=imp$featuredata,
                       factormat=factormat,
                       ruv2=TRUE,k=2,
                       qcmets = which(metabolitedata_eg$IS ==1))
ruv2Fit

#Exploring metabolites associated with age
lcoef_age<-list(unadjusted=unadjustedFit$coefficients[,"Age"],
               is_age=isFit$coefficients[,"Age"],
               ruv2_age=ruv2Fit$coefficients[,"Age"])
lpvals_age<-list(unadjusted=unadjustedFit$p.value[,"Age"],
                is=isFit$p.value[,"Age"],
                ruv2=ruv2Fit$p.value[,"Age"])

negcontrols<-metabolitedata_eg$names[which(metabolitedata_eg$IS==1)]                   

CompareVolcanoPlots(lcoef=lcoef_age, 
                   lpvals_age, 
                   xlab="Coef",
                   negcontrol=negcontrols)

}
\seealso{
\code{\link{VolcanoPlot}}
}
\author{
Alysha M De Livera, Gavriel Olshansky
}
