% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nonpareil.R
\name{summary.Nonpareil.Curve}
\alias{summary.Nonpareil.Curve}
\title{Returns a summary of the \code{Nonpareil.Curve} results.}
\usage{
\method{summary}{Nonpareil.Curve}(object, ...)
}
\arguments{
\item{object}{\code{Nonpareil.Curve} object.}

\item{...}{Additional parameters ignored.}
}
\value{
Returns a matrix with the following values for the dataset:
\itemize{
  \item kappa: "Redundancy" value of the entire dataset.
  \item C: Average coverage of the entire dataset.
  \item LRstar: Estimated sequencing effort required to reach the objective
    average coverage (star, 95% by default).
  \item LR: Actual sequencing effort of the dataset.
  \item modelR: Pearson's R coefficient betweeen the rarefied data and the
    projected model.
  \item diversity: Nonpareil sequence-diversity index (Nd). This value's
    units are the natural logarithm of the units of sequencing effort
    (log-bp), and indicates the inflection point of the fitted model for
    the Nonpareil curve. If the fit doesn't converge, or the model is not
    estimated, the value is zero (0).
}
}
\description{
Returns a summary of the \code{Nonpareil.Curve} results.
}
