% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NonProbEst.R
\name{total_estimation}
\alias{total_estimation}
\title{Estimates the population totals}
\usage{
total_estimation(sample, weights, estimated_vars, N)
}
\arguments{
\item{sample}{A data frame containing the sample with the variables for which the estimated population totals are to be calculated.}

\item{weights}{A vector of pre-calculated weights.}

\item{estimated_vars}{String vector specifying the variables in the sample to be estimated.}

\item{N}{An integer specifying the population size.}
}
\value{
A vector with the corresponding estimations.
}
\description{
Estimates the population totals for the specified variables measured in a sample given some pre-calculated weights.
}
\examples{
covariates = c("education_primaria", "education_secundaria", "education_terciaria")
data_propensities = propensities(sampleNP, sampleP, covariates)
psa_weights = sc_weights(data_propensities$convenience)
total_estimation(sampleNP, psa_weights, c("vote_pens"), 50000)
}
