% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/purrr-misc.R
\name{keep_at}
\alias{keep_at}
\alias{discard_at}
\title{Keep or discard elements}
\usage{
keep_at(.x, .at)

discard_at(.x, .at)
}
\arguments{
\item{.x}{A list or vector.}

\item{.at}{Character (column names) or a numeric (positions).}
}
\value{
A list or vector.
}
\description{
\code{keep_at()} keeps only the elements from specific positions or
  columns, while \code{discard_at()} does the opposite.
  The functions are wrappers around \code{purrr::keep} and
  \code{purrr::discard}, respectively.
}
\examples{
x <- c(1, 2, 3)
names(x) <- c("First", "Second", "Last")
keep_at(x, "Second")
# returns 2

x <- c(1, 2, 3)
discard_at(x, 1)
# returns (2, 3)

}
\seealso{
\code{\link[purrr:keep]{purrr::keep}}
}
