% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modules.R
\name{varmlp}
\alias{varmlp}
\title{Artificial Neural Network VAR (Vector Auto-Regressive) model using a MultiLayer Perceptron, with the sigmoid activation function. The optimization algorithm is based on the stochastic gradient descent.}
\usage{
varmlp(
  df,
  lag,
  sizeOfHLayers,
  iters,
  bias = TRUE,
  learningRate = 0.1,
  algo = "sgd",
  activations = vector()
)
}
\arguments{
\item{df}{A numerical dataframe}

\item{lag}{The lag parameter.}

\item{sizeOfHLayers}{Integer vector that contains the size of hidden layers, where the length of this vector is the number of hidden layers, and the i-th element is the number of neurons in the i-th hidden layer.}

\item{iters}{The number of iterations.}

\item{bias}{Logical, true if the bias have to be used in the network.}

\item{learningRate}{The learning rate to use, O.1 by default, and if Adam algorithm is used, then it is the initial learning rate.}

\item{algo}{String argument, for the optimisation algorithm to use, in choice ["sgd", "adam"]. By default "sgd" (stochastic gradient descent) is used. The algorithm 'adam' is to adapt the learning rate while using "sgd".}

\item{activations}{String vector for the activations functions to use (in choice ["sigmoid", "relu", "tanh"]). The length of this vector is the number of hidden layers plus one (the output layer). By default, the relu activation function is used in hidden layers, and the sigmoid in the last layer.}
}
\value{
train (df):  updates the parameters of the model using the input dataframe.

forecast (df):  makes forecasts of an given dataframe. The forecasts include the forecasted row based on each previous "lag" rows, where the last one is the next forecasted row of  df.
}
\description{
Artificial Neural Network VAR (Vector Auto-Regressive) model using a MultiLayer Perceptron, with the sigmoid activation function. The optimization algorithm is based on the stochastic gradient descent.
}
\details{
This function builds the model, and returns an object that can be used to make forecasts and can be updated from new data.
}
\examples{
library (timeSeries) # to extract time series
library (NlinTS)
#load data
data = LPP2005REC
# Predict the last row of the data
train_data = data[1:(nrow (data) - 1), ]
model = varmlp (train_data, 1, c(10), 20, bias = TRUE, learningRate=0.1, algo = "sgd");
predictions = model$forecast (train_data)
print (predictions[nrow (predictions),])
}
