% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustcoeff.R
\name{clustcoeff}
\alias{clustcoeff}
\title{Clustering Coefficient}
\usage{
clustcoeff(A, weighted = FALSE)
}
\arguments{
\item{A}{An adjacency matrix of network data}

\item{weighted}{Is the network weighted?
Defaults to FALSE.
Set to TRUE for weighted measures of CC and CCi}
}
\value{
Returns a list containing:

\item{CC}{Global clustering coefficient}

\item{CCi}{Local clustering coefficient}
}
\description{
Computes global clustering coefficient (CC) and local clustering coefficient (CCi)
}
\examples{
A <- TMFG(neoOpen)$A

#Unweighted CC
CCu <- clustcoeff(A)

#Weighted CC
CCw <- clustcoeff(A, weighted=TRUE)

}
\references{
Rubinov, M., & Sporns, O. (2010). 
Complex network measures of brain connectivity: Uses and interpretations. 
\emph{Neuroimage}, \emph{52}, 1059-1069.
doi: \href{https://doi.org/10.1016/j.neuroimage.2009.10.003}{10.1016/j.neuroimage.2009.10.003}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
