% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kld.R
\name{kld}
\alias{kld}
\title{Kullback-Leibler Divergence}
\usage{
kld(base, test)
}
\arguments{
\item{base}{Full or base model}

\item{test}{Reduced or testing model}
}
\value{
A value greater than 0.
Smaller values suggest the probablity distribution of the reduced model is near the full model
}
\description{
Estimates the Kullback-Leibler Divergence which measures how one probability distribution
diverges from the original distribution (equivalent means are assumed)
Matrices \strong{must} be positive definite inverse covariance matrix for accurate measurement.
This is not a quantitative metric
}
\examples{
A1 <- solve(cov(neoOpen))

A2 <- LoGo(neoOpen)

kld_value <- kld(A1, A2)

}
\references{
Kullback, S., & Leibler, R. A. (1951).
On information and sufficiency.
\emph{The Annals of Mathematical Statistics}, \emph{22}, 79-86.
doi: \href{https://doi.org/10.1214/aoms/1177729694}{10.1214/aoms/1177729694}
}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
