% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pperm.R
\name{permp}
\alias{permp}
\title{Exact permutation p-values wrapper}
\usage{
permp(x, nperm, ...)
}
\arguments{
\item{x}{number of permutations that yielded test statistics at least as 
extreme as the observed data. May be a vector or an array of values.}

\item{nperm}{total number of permutations performed.}

\item{...}{other arguments to pass to\code{\link[statmod]{permp}}.}
}
\value{
vector or array of p-values, of same dimensions as \code{x}.
}
\description{
Wrapper for \code{\link[statmod]{permp}} from the 
\code{\link[statmod]{statmod}} library, which can crash if FORTRAN 
libraries are not properly linked.
}
\details{
In the case \code{\link[statmod]{permp}} fails, the wrapper will fall back 
to a slightly more conservative biased estimator: (1+x)/(1+nPerm).
}

