% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/netint.R
\name{WA.int}
\alias{WA.int}
\title{Weighted Average (WA) network integration}
\usage{
WA.int(M, logint = FALSE, ...)
}
\arguments{
\item{M}{a numeric matrix with the values of the metric used to compute the alpha
coefficients for each class and for each network.
Rows correspond to networks and columns to classes. Element (i,j) of the
matrix corresponds to the value of the metric (e.g. AUC) for the ith
network and the jth class.}

\item{logint}{logic. If TRUE the mean values m are log transformed: -log(1-m),
otherwise a linear integration is performed (def: FALSE).}

\item{...}{a list of numeric matrices. These must be named matrices representing
adjacency matrices of the networks. Matrices may have different dimensions,
but corresponding elements in different matrices must have the same name.}
}
\value{
A list with two elements:
\itemize{
\item WA : the matrix resulting from WA
\item alpha : a numeric vector with the weight coefficients of the networks
}
}
\description{
It performs the WA integration between networks.

Note that this function puts more weight (alpha parameter) for networks with
associated larger M. The alphas are computed by averaging across the alpha
of each class, and hence a unique integrated network is available for all the
considered classes.
}
\examples{
# Create three example networks of different size
set.seed(123);
A1 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A1[lower.tri(A1)] = t(A1)[lower.tri(A1)];
diag(A1) <- 0;
rownames(A1) <- colnames(A1) <- sample(LETTERS, 10);

A2 <- matrix(runif(49, min = 0, max = 1), nrow = 7);
A2[lower.tri(A2)] = t(A2)[lower.tri(A2)];
diag(A2) <- 0;
rownames(A2) <- colnames(A2) <- rownames(A1)[1:7];

A3 <- matrix(runif(100, min = 0, max = 1), nrow = 10);
A3[lower.tri(A3)] = t(A3)[lower.tri(A3)];
diag(A3) <- 0;
rownames(A3) <- colnames(A3) <- c(rownames(A1)[1:5], c("A", "B", "Z", "K", "Q"));

# Create random matrix of accuracy metrics (considering 3 classes)
M <- matrix(runif(9, min = 0, max = 1), ncol = 3);

# Integrate networks using Weighted Average (WA) method
A_int <- WA.int(M, logint=TRUE, A1, A2, A3);
}
