% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets.R
\docType{data}
\name{quality}
\alias{quality}
\title{Perception of food quality}
\format{
A data frame with 55 rows and 9 columns. Here is the list of logos:
\itemize{
\item AB: organic;
\item Label Rouge: superior quality (from the taste, process, packaging...);
\item FairTrade: decent wages and working conditions for the producers;
\item Bleu Blanc Coeur: diverse and balanced diet for the livestock;
\item AOC: controlled designation of origin;
\item Produit en Bretagne: processed in Brittany;
\item Viandes de France: livestock bred, grown and slaughtered in France, with respectful living conditions;
\item Nourri sans OGM: no GMOs in livestock food;
\item Médailles Agro: a prize won at a yearly contest based on taste.
}
}
\source{
Sébastien Lê, applied mathematics department, Institut Agro Rennes-Angers
}
\usage{
quality
}
\description{
These data were collected after a study on the perception of food quality.
Participants were given 9 French logos; they had to rate, on a scale from 0 (not at all) to 10 (absolutely), how much a product bearing them aligned with their own perception of quality.
}
\examples{
\dontrun{
# Processing time is often longer than ten seconds
# because the function uses a large language model.

library(NaileR)
data(quality)

colnames(quality) <- c("Agriculture biologique",
"Label Rouge",
"FairTrade",
"Bleu Blanc Coeur",
"Appelation d'origine contrôlée",
"Produit en Bretagne",
"Viandes de France",
"Nourri sans OGM",
"Médailles Agro")

res_pca_quality <- FactoMineR::PCA(quality, graph = FALSE)
quali_work <- res_pca_quality$ind$coord |> as.data.frame()
quali_work <- quali_work[,1] |> cbind(quality)

intro_quali <- "These data were collected after a study
on the perception of food quality.
Participants were given 9 French logos;
they had to rate, on a scale from 0 (not at all)
to 10 (absolutely), how much a product bearing them
aligned with their own perception of quality."
intro_quali <- gsub('\n', ' ', intro_quali) |>
stringr::str_squish()

res_quality <- nail_condes(quali_work, num.var = 1,
quanti.cat = c('Higher quality', 'Lower quality', 'Neutral'),
introduction = intro_quali, generate = FALSE)

ppt <- gsub('characteristics', 'opinions', res_quality$prompt)

res_quality <- ollamar::generate('llama3', ppt, output = 'df')

cat(res_quality$response)
}
}
\keyword{datasets}
