% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{uTAR.pred}
\alias{uTAR.pred}
\title{Prediction of A Fitted Univariate TAR Model}
\usage{
uTAR.pred(model, orig, h = 1, iterations = 3000, ci = 0.95, output = TRUE)
}
\arguments{
\item{model}{univariate TAR model.}

\item{orig}{forecast origin.}

\item{h}{forecast horizon.}

\item{iterations}{number of iterations.}

\item{ci}{confidence level.}

\item{output}{a logical value for output, default is TRUE.}
}
\value{
uTAR.pred returns a list with components:
\item{model}{univariate TAR model.}
\item{pred}{prediction.}
\item{Ysim}{fitted y.}
}
\description{
Prediction of a fitted univariate TAR model.
}
\examples{
phi=t(matrix(c(-0.3, 0.5,0.6,-0.3),2,2))
y=uTAR.sim(nob=2000, arorder=c(2,2), phi=phi, d=2, thr=0.2, cnst=c(1,-1),sigma=c(1, 1))
thr.est=uTAR.grid(y=y$series, p1=2, p2=2, d=2, thrQ=c(0,1),Trim=c(0.1,0.9))
est=uTAR.est(y=y$series, arorder=c(2,2), thr=thr.est$thr, d=2)
uTAR.pred(mode=est, orig=2000,h=1,iteration=100,ci=0.95,output=TRUE)
}
