% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pool.R
\name{coxph.pool}
\alias{coxph.pool}
\title{Estimate Cox regression model pooling over the imputed datasets}
\usage{
coxph.pool(obj, time, status, Z, forceNumeric = FALSE, setRef = NULL)
}
\arguments{
\item{obj}{A 'nnmi' object, that contains a finite number of imputations
of the missing data.}

\item{time}{A vector contains the observed time.}

\item{status}{A vector contains the event indicator.}

\item{Z}{A vector or matrix that contains other covariates.}

\item{forceNumeric}{Logical, if it is True, the class of imputed variable will force to be numeric.
The default is FALSE.}

\item{setRef}{Optional, a reference group can be set for binary or categorical variable.}
}
\value{
A data frame contains pooled estimation of Cox regression model.
}
\description{
This function estimates Cox regression model, taking into account
the additional uncertainty that arises due to a finite number of
imputations of the missing data.
}
\examples{

# load required packages
library(NNMIS)
library(survival)

# load data set - stanford2 in package 'survival'
data("stanford2")
head(stanford2)
attach(stanford2)

# performance multiple imputation on missing covariate t5
imp.dat <- NNMIS(t5, xa=age, xb=age, time=time, event=status, Seed = 1234)

# this program can impute survival times for censored observations based
# on the imputed missing covariate values

\dontrun{
imp.dat <- NNMIS(t5, xa=age, xb=age, time=time, event=status, imputeCT=TRUE, Seed = 1234)
#check imputation results
head(imp.dat$dat.NNMI)    # imputed missing covariate values
head(imp.dat$dat.T.NNMI)  # imputed survival times
head(imp.dat$dat.Id.NNMI) # censoring indicator
}

# check imputation results
head(imp.dat$dat.NNMI)

# combine inference from imputed data sets by using Rubin's rules
# estimates in Cox regression
coxph.pool(imp.dat, time, status, age)

}
