% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readParsWide.R
\name{readParsWide}
\alias{readParsWide}
\title{Parameter data from csv}
\usage{
readParsWide(
  data,
  col.model = NULL,
  strings.par.type = c(THETA = "^T.*", OMEGA = "^O.*", SIGMA = "^S."),
  as.fun
)
}
\arguments{
\item{data}{A data.frame or a path to a delimited file to be read
using `data.table::fread`.}

\item{col.model}{Name of the model counter, default is "model". If
the provided name is not found in data, it will be created as
a row counter. Why needed? Each row in data represents a set
of parameters, i.e. a model. In the long format result, each
model will have multiple rows. Hence, a model identifier is
needed to distinguish between models in results.}

\item{strings.par.type}{Defines how column names get associated
with THETA, OMEGA, and SIGMA. Default is to look for "T", "O",
or "S" as starting letter. If customizing, make sure each no
column name will be matched by more than one criterion.}

\item{as.fun}{The default is to return data as a data.frame. Pass
a function (say \code{tibble::as_tibble}) in as.fun to convert to
something else. If data.tables are wanted, use
as.fun="data.table". The default can be configured using
NMdataConf.}
}
\value{
a long-format data.frame of model parameters
}
\description{
Reads output table from simpar and returns a long format
data.table. This is the same format as returned by NMreadExt()
which can be used by NMsim.
}
\details{
The wide data format read by `readParsWide` is not a Nonmem
    format. It is used to bridge output from other tools such as
    simpar, and potentially PSN. 

This function reads a data that is "wide" in parameters - it has a
    column for each parameter, and one row per parameter set or
    "model". It returns a data set that is "long" in model and
    parameters. The long format contains
\itemize{
\item id.model.par The unique model-parameter identifier. The row-identifier.
\item model Model identifier. 
\item par.type ("THETA", "OMEGA", "SIGMA")
\item i and j indexes for the parameters (j is NA for par.type=="THETA").
\item value The parameter value 
\item parameter Nonmem-style parameter names. THETA1, OMEGA(1,1) etc. Notice the inconsistent naming of THETA vs others.
\item name.wide The column name in the wide data where this value was taken
}
The columns or "measure variables" from which to read values  are
    specified as three regular expressions, called THETA, OMEGA, and SIGMA. The default three regular expressions will associate a column name starting with "T" with THETAs, while "O" or "S" followed by anything means "OMEGA" or "SIGMA".

readParsWide extracts i and j indexes from sequences of digits in the column names. TH.1 would be TETA1, SG1.1 is SIGMA(1,1).
}
\examples{
\dontrun{
tab.ext <- readParsCsv("simpartab.csv")
## or
tab.simpar <- fread("simpartab.csv")
tab.ext <- readParsCsv(tab.simpar)
NMsim(...,method.sim=NMsim_VarCov,tab.ext=tab.ext)
}
}
