% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-diagnostics.R
\name{ppc_data}
\alias{ppc_data}
\alias{ppc}
\alias{ppc_whisker_plot}
\alias{ppc_histogram_plot}
\title{PPC functions: process data from simulation and plot}
\usage{
ppc_data(
  r,
  FUN,
  ...,
  pre_proc = identity,
  max_mod_no = NA,
  DV = "DV",
  statistic = "statistic"
)

ppc_whisker_plot(d, group, var1, var2, statistic = "statistic")

ppc_histogram_plot(d, var1, var2, statistic = "statistic")
}
\arguments{
\item{r}{An nm object (a simulation run).}

\item{FUN}{Statistic function accepting a NONMEM dataset \code{data.frame} as an
argument and returns \code{data.frame} with a column \code{"statistic"}.}

\item{...}{Additional arguments for \code{FUN}.}

\item{pre_proc}{Function to apply to dataset prior to compute statistics.}

\item{max_mod_no}{Integer. Maximum model number to read (set low for debugging).}

\item{DV}{Character (default = \code{"DV"}).}

\item{statistic}{Character (default = \code{"statistic"}). Name of statistic column
returned by FUN.}

\item{d}{Output from \code{\link[=ppc_data]{ppc_data()}}.}

\item{group, var1, var2}{Grouping variables for plotting.}
}
\value{
The function \code{ppc_data()} return a \code{data.frame} with observed and
predicted statistics. The \verb{ppc_*_plot()} plotting functions return \code{ggplot}
objects.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}
}
\examples{

## requires NONMEM to be installed
\dontrun{

idEXPstat <- function(d, ...) { ## example individual statistic function
  ## arg = nonmem dataset data.frame
  ## return data.frame with statistic column
  d \%>\%
    group_by(ID, ...) \%>\%
    filter(is.na(AMT)) \%>\%
    summarise(
      AUC = AUC(time = TIME, conc = DV),
      CMAX = max(DV, na.rm = TRUE),
      TMAX = TIME[which.max(DV)]
    ) \%>\%
    tidyr::gather(key = "exposure", value = "statistic", AUC:TMAX) \%>\%
    ungroup()
}

EXPstat <- function(d, ...) { ## example summary statistic function
  ## arg = nonmem dataset data.frame
  ## return data.frame with statistic column
  d \%>\%
    idEXPstat(...) \%>\% ## reuse idEXPstat for individual stats
    ## summarise over study and any other variables (...)
    group_by(exposure, ...) \%>\%
    summarise(
      median = median(statistic, na.rm = TRUE),
      cv = 100 * sd(statistic, na.rm = TRUE) / mean(statistic, na.rm = TRUE)
    ) \%>\%
    tidyr::gather(key = "type", value = "statistic", median:cv)
}

dppc <- m1s \%>\% ppc_data(EXPstat)

dppc \%>\% ppc_whisker_plot()
dppc \%>\% ppc_forest_plot()
}
}
\seealso{
\code{\link[=nm_render]{nm_render()}}
}
