% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/derived-data-prep.R
\name{read_derived_data}
\alias{read_derived_data}
\title{Read derived data}
\usage{
read_derived_data(name, na = ".", silent = FALSE, ...)
}
\arguments{
\item{name}{Name or path of file (with or without extension).}

\item{na}{Character to be passed to \code{\link[utils:read.table]{utils::read.csv()}}.}

\item{silent}{Logical (default = \code{TRUE}). Should messages be suppressed.}

\item{...}{Additional arguments to be passed to \code{\link[utils:read.table]{utils::read.csv()}}.}
}
\value{
A \code{data.frame} object of the NONMEM dataset.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Read the derived data directly instead of via the nm object which is what
\code{\link[=input_data]{input_data()}} does.
}
\examples{

## requires NMproject directory structure to operate in
\dontrun{

## read a dataset that's been copie into SourceData
d <- read.csv("SourceData/orig_data.csv")

## modify it
d <- d[d$ID < 10, ]

d \%>\% write_derived_data("DerivedData/data.csv")

## load it again either with
d <- read_derived_data("data")

## or more commonly if it is associated with run (e.g. m1),
## you can use input_data() to load it via the nm object

d <- input_data(m1)
}
}
\seealso{
\code{\link[=write_derived_data]{write_derived_data()}}, \code{\link[=input_data]{input_data()}}, \code{\link[=exclude_rows]{exclude_rows()}}.
}
