% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC_EMP.R
\name{SPC_EMP}
\alias{SPC_EMP}
\title{SPC_EMP}
\usage{
SPC_EMP(specdat)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
A single linear model with entropy minimization with negative peak penalty
}
\details{
This function is to process phase error correction through a single linear model with entropy minimization with negative peak penalty,
followed by Polynomial baseline correction
}
\examples{
data("fdat")
mpc_emp_phased1 <- SPC_EMP(fdat$frequency_domain)
}
\references{
Binczyk F, Tarnawski R, Polanska J (2015) Strategies for optimizing the phase correction algorithms in Nuclear Magnetic Resonance spectroscopy. Biomed Eng Online 14 Suppl 2:S5.

de Brouwer, H. (2009). Evaluation of algorithms for automated phase correction of NMR spectra. J Magn Reson, 201, 230-238.

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
