% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPC_AAM.R
\name{SPC_AAM}
\alias{SPC_AAM}
\title{SPC_AAM}
\usage{
SPC_AAM(specdat)
}
\arguments{
\item{specdat}{A complex number vector of observed frequency domain data}
}
\value{
A numeric vector of phase corrected absorption spectrum
}
\description{
A single linear model with minimization on absolute area
}
\details{
This function is to process phase error correction through a single linear model with minimization on absolute area, followed by
   Polynomial baseline correction
}
\examples{
data("fdat")
spc_aam_phased1 <- SPC_AAM(fdat$frequency_domain)
}
\references{
de Brouwer, H. (2009). Evaluation of algorithms for automated phase correction of NMR spectra. J Magn Reson, 201, 230-238.

Dzakula, Z. (2000). Phase angle measurement from peak areas (PAMPAS). J Magn Reson, 146, 20-32.

Liland KH, Almøy T, Mevik B (2010), Optimal Choice of Baseline
Correction for Multivariate Calibration of Spectra, Applied Spectroscopy 64, pp. 1007-1016.
}
\author{
Aixiang Jiang
}
\concept{phase correction}
