% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-original-bipartite-interactive.R
\name{plotBipartiteInteractive}
\alias{plotBipartiteInteractive}
\title{Use the incidence matrix to plot an interactive bipartite graph figure}
\usage{
plotBipartiteInteractive(inc_mat)
}
\arguments{
\item{inc_mat}{A matrix, the incidence matrix of graph.}
}
\value{
An visNetwork interactive figure, details in \code{\link[visNetwork]{visNetwork}}
}
\description{
This function converts the input incidence matrix into a
bipartite graph, and uses the visNetwork package to draw an interactive
figure.
}
\details{
This function realizes interactive visualization. The user can input
a simple incidence matrix, and then get a dynamic graph with a bipartite
graph layout, in which two parts use different colors and shapes to
represent nodes.
}
\examples{
# load part of the beatAML data
beatAML_data <- NIMAA::beatAML[1:1000,]

# plot beatAML data and convert to incidence matrix
beatAML_incidence_matrix <- el2IncMatrix(beatAML_data, print_skim = FALSE)

plotBipartiteInteractive(inc_mat = beatAML_incidence_matrix)
}
\seealso{
\code{\link[visNetwork]{visNetwork}}
}
