% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/impute-missing-values.R
\name{imputeMissingValue}
\alias{imputeMissingValue}
\title{Impute the missing value in the given matrix.}
\usage{
imputeMissingValue(inc_mat, method = c("svd", "median", "als", "CA"))
}
\arguments{
\item{inc_mat}{A matrix containing missing values, represented by NAs.}

\item{method}{A string or list of string, can be one of them, or belong to
the interpolation method suitable for numerical data in the MICE
package.Default is a list, c('svd','median','als','CA'), other options
could be in MICE or 'knn', 'FAMD', 'PCA', 'pmm'.}
}
\value{
A list of matrices without missing values
}
\description{
This function will call several data imputation methods, where
the columns of the matrix are different objects, and the rows represent
multiple observations.
}
\details{
First, this function will convert the column name and row name to
avoid possible interpolation failures caused by the special characters of
the column name and row name. Then it will perform a variety of numerical
imputation according to the user's input, and return all the data that does
not contain any missing data, a list of matrices. 'median' will replace the
missing values with the median of each rows(observations), 'knn' is the
method in package \code{bnstruct}, 'als' and 'svd' are methods from
package \code{softImpute}, 'CA', 'PCA' and 'FAMD' are from package
\code{missMDA}, others are from the famous \code{mice}.
}
\examples{
# load part of beatAML data
data <- NIMAA::beatAML[1:10000,]

# convert to incidence matrix
inc_mat <- el2IncMatrix(data, print_skim = FALSE)

# impute
imputeMissingValue(inc_mat)
}
\seealso{
\code{\link[bnstruct]{knn.impute}},
\code{\link[softImpute]{softImpute}}, \code{\link[missMDA]{imputeCA}},
\code{\link[missMDA]{imputeFAMD}}, \code{\link[missMDA]{imputePCA}},
\code{\link[mice]{mice}}.
}
