% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getShrinkedDispersions.R
\name{getShrinkedDispersions}
\alias{getShrinkedDispersions}
\title{Estimate Shrinked Overdispersions}
\usage{
getShrinkedDispersions(obs, shrinkTarget = NULL, delta = NULL)
}
\arguments{
\item{obs}{a numeric vector. Initial dispersion estimates for each feature.}

\item{shrinkTarget}{a numeric value. initial dispersion estimates are shrinked towards
this value. If NULL, target value is estimated from initial dispersion estimates. See notes.}

\item{delta}{a numeric value. This is the weight that is used for shrinkage algorithm. If 0,
no shrinkage is performed on intiial values. If equals 1, initial values are forced to shrinked
to target value. If NULL, weight are automatically estimated from initial disperson estimates.}
}
\value{
a list with elements of initial and adjusted (shrinked) dispersion estimates, shrinkage target and
weight that is used to shrink towards target value. See related paper for detailed information on shrinkage
algorithm (Yu et. al., 2013).
\item{initial}{initial estimates for dispersions estimated from method-of-momnets.}
\item{adj}{shrinked dispersion estimates.}
\item{cmp}{mean and variance of initial estimates.}
\item{delta}{a weight used for shrinkage estimates. See Yu et. al. (2013) for details.}
\item{target}{shrinkage target for initial dispersion estimates.}
}
\description{
Use this function to shrink initial estimates of overdispersions towards a target value.
}
\note{
This function is modified using source code from \code{\link[sSeq]{getAdjustDisp}}.
}
\examples{
set.seed(2128)
initial <- runif(10, 0, 4)

getShrinkedDispersions(initial, 0)  # shrink towards 0.
getShrinkedDispersions(initial, 0, delta = 1)  # force to shrink 0.

}
\references{
Yu, D., Huber, W., & Vitek, O. (2013). Shrinkage estimation of dispersion in Negative Binomial models
for RNA-seq experiments with small sample size. Bioinformatics, 29(10), 1275-1282.
}
\seealso{
\code{\link[sSeq]{getT}}, \code{\link[sSeq]{getAdjustDisp}}
}
\author{
Dincer Goksuluk
}
