% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TN.R
\name{TN}
\alias{TN}
\title{Generate Plant Trait Network}
\usage{
TN(traits_matrix, rThres = 0.2, pThres = 0.05, method = "pearson")
}
\arguments{
\item{traits_matrix}{A numeric matrix where each column represents a plant trait and each row represents a sample.}

\item{rThres}{Numeric, threshold for correlation coefficient, default is 0.2. Correlations with absolute values below this threshold are set to zero.}

\item{pThres}{Numeric, threshold for p-value, default is 0.05. Only correlations with p-values below this threshold are included in the network.}

\item{method}{Character, specifies the correlation method to use: "pearson" (default) or "spearman".}
}
\value{
Returns an igraph object representing the trait network.
}
\description{
This function creates a network graph from a plant trait correlation matrix, applying thresholds for correlation strength and significance.
}
\details{
The function performs the following steps:
\enumerate{
\item Calculates Pearson correlation coefficients and p-values for the trait matrix.
\item Applies correlation coefficient and p-value thresholds to filter relationships.
\item Constructs a weighted undirected graph from the filtered correlation matrix.
\item Removes self-loops and isolated nodes from the graph.
\item Adds correlation coefficients as edge attributes.
}
}
\examples{
data(PFF)
PFF_traits <- PFF[, c("Height", "Leaf_area","LDMC","SLA","SRL","SeedMass","FltDate",
                      "FltDur","Leaf_Cmass","Leaf_Nmass","Leaf_CN","Leaf_Pmass",
                      "Leaf_NP","Leaf_CP","Root_Cmass","Root_Nmass","Root_CN")]
PFF_traits <- na.omit(PFF_traits)
head(PFF_traits)
Tn_result <- TN(traits_matrix = PFF_traits, rThres = 0.2, pThres = 0.05, method = "pearson")
Tn_result

}
\references{
\enumerate{
\item He, N., Li, Y., Liu, C., et al. (2020). Plant trait networks: improved resolution of the dimensionality of adaptation. Trends in Ecology & Evolution, 35(10), 908-918. https://doi.org/10.1016/j.tree.2020.06.003
\item Li, Y., Liu, C., Sack, L., Xu, L., Li, M., Zhang, J., & He, N. (2022). Leaf trait network architecture shifts with species‐richness and climate across forests at continental scale. Ecology Letters, 25(6), 1442-1457. https://doi.org/10.1111/ele.14009
}
}
