% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Distributions.R
\name{MomCumCFUSN}
\alias{MomCumCFUSN}
\title{Moments and cumulants CFUSN}
\usage{
MomCumCFUSN(r, d, p, Delta, nMu = FALSE)
}
\arguments{
\item{r}{The highest cumulant order}

\item{d}{The multivariate dimension and number of rows of the skewness matrix Delta}

\item{p}{The number of cols of the skewness matrix Delta}

\item{Delta}{The skewness matrix}

\item{nMu}{If set to TRUE, the list of the first r d-variate moments is provided}
}
\value{
The list of theoretical  cumulants in vector form
}
\description{
Provides the theoretical cumulants of the multivariate Canonical Fundamental
Skew Normal distribution
}
\examples{
r <- 4; d <- 2; p <- 3
Lamd <-  matrix(sample(1:50-25, d*p), nrow=d)
ieg<- eigen(diag(p)+t(Lamd)\%*\%Lamd)
V <- ieg$vectors
Delta <-Lamd \%*\% V \%*\% diag(1/sqrt(ieg$values)) \%*\% t(V)
MomCum <- MomCumCFUSN(r,d,p,Delta)
}
\references{
Gy.Terdik, Multivariate statistical methods - Going beyond the linear,
Springer 2021, Lemma 5.3 p.251
}
\seealso{
Other Moments and cumulants: 
\code{\link{Cum2Mom}()},
\code{\link{EVSKSkewNorm}()},
\code{\link{EVSKUniS}()},
\code{\link{Mom2Cum}()},
\code{\link{MomCumSkewNorm}()},
\code{\link{MomCumUniS}()},
\code{\link{MomCumZabs}()}
}
\concept{Moments and cumulants}
