\name{BinToOrd}
\alias{BinToOrd}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Converts multivariate binary data to multivariate ordinal data
}
\description{
Converts multivariate binary data to multivariate ordinal data using original ordinal probabilities.
}
\usage{
BinToOrd(prop.vec.bin, ordPmat, Mlocation, bin.data)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{prop.vec.bin}{
Vector of marginal probabilities. It is usually a first component of the 
list returned by \code{\link{find.binary.prob}}
}
  \item{ordPmat}{
Input matrix of ordinal marginal probabilities
}
  \item{Mlocation}{
Vector of locations where dichotomization is done. It is usually a second component of the list 
returned by \code{\link{find.binary.prob}}
}
  \item{bin.data}{
	Matrix of binary data generated using \code{\link{generate.binary}}
}
}
\details{
As a part of the multivariate ordinal data generation, intermediate multivariate binary data are generated. 
This function converts multivariate binary data generated by  \code{\link{generate.binary}} to the 
multivariate ordinal data.
}
\value{
  \item{y}{Matrix of multivariate ordinal data}
  \item{Corr}{Correlation matrix of \code{y}}
}
\examples{
\dontrun{	nObs = 1000; no.rows = 100000 }
\dontrun{	ordPmat1 = matrix( c(0.15,0.70,0.40,
					0.55,0.10,0.25,
					0.25,0.10,0.15,
					0.05,0.10,0.20),4,3,byrow=TRUE) }
					
\dontrun{\	cmat1= matrix( 	c(1,0.2,0.2,
				0.2,1,0.2,
				0.2,0.2,1),3,3,byrow=TRUE) }
				
\dontrun{	binObj = simBinCorr(ordPmat1, cmat1, no.rows) }
\dontrun{	ep0 = generate.binary( nObs, binObj$pvec, binObj$del.next) }
\dontrun{	Mydata= BinToOrd(binObj$pvec, ordPmat1, binObj$Mlocation, ep0) 	}
}

