% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/multiObjMatch.R
\name{compareTables}
\alias{compareTables}
\title{Summarize covariate balance table}
\usage{
compareTables(balanceTable)
}
\arguments{
\item{balanceTable}{a named list, which is the result from the function
\code{generateBalanceTable}}
}
\value{
a dataframe with combined information
}
\description{
This function would take the result of \code{generateBalanceTable}
function and combine the results in a single table. It only works for 'Basic'
version of the matching.
}
\examples{
## Generate matches 
data("lalonde", package="cobalt")
psCols <- c("age", "educ", "married", "nodegree")
treatVal <- "treat"
responseVal <- "re78"
pairDistVal <- c("age", "married", "educ", "nodegree")
exactVal <- c("educ")
myBalVal <- c("race")
r1s <- c( 0.1, 0.3, 0.5, 0.7, 0.9,1, 1.1, 1.2, 1.3, 1.4, 1.5, 1.6, 1.7)
r2s <- c(0.01)
matchResult <- distBalMatch(df=lalonde, treatCol=treatVal, myBalCol=myBalVal,
rhoExclude =r1s, rhoBalance=r2s,
distList=pairDistVal, exactlist=exactVal,
propensityCols = psCols,ignore = c(responseVal), maxUnMatched = 0.1,
caliperOption=NULL, toleranceOption=1e-1, maxIter=0, rho.max.f = 10)

## Generate summary table for comparing matches 
compareTables(generateBalanceTable(matchResult))
}
