% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Bootstrap.R
\name{Gen_Artificial_Series}
\alias{Gen_Artificial_Series}
\title{Generate artificial time-series in the bootstrap setup}
\usage{
Gen_Artificial_Series(
  ModelParaPE,
  residPdynOriginal,
  residYieOriginal,
  ModelType,
  BFull,
  InputsForOutputs,
  Economies,
  FactorLabels,
  GVARlist,
  JLLlist,
  WishBRW,
  BRWlist,
  nlag = 1
)
}
\arguments{
\item{ModelParaPE}{list of point estimates of the model parameter}

\item{residPdynOriginal}{Time-series of the residuals from the P-dynamics equation (T x F)}

\item{residYieOriginal}{Time-series of the residuals from the observational equation (T x J or T x CJ)}

\item{ModelType}{Desired model to be estimated}

\item{BFull}{matrix B of loadings (CJ x F or J x F)}

\item{InputsForOutputs}{list containing the desired inputs for the construction}

\item{Economies}{string-vector containing the names of the economies which are part of the economic system}

\item{FactorLabels}{string-list based which contains the labels of all the variables present in the model}

\item{GVARlist}{list of necessary inputs for the estimation of GVAR-based models}

\item{JLLlist}{list of necessary inputs for the estimation of JLL-based models}

\item{WishBRW}{Whether the user wishes to estimate the physical parameter model with the Bias correction model from BRW (2012) (see "Bias_Correc_VAR" function).\cr
Default is set to 0.}

\item{BRWlist}{list of necessary inputs for performing the bias-corrected estimation (see "Bias_Correc_VAR" function)}

\item{nlag}{Number of lags in the P-dynamics. Default is set to 1.}
}
\description{
Generate artificial time-series in the bootstrap setup
}
\keyword{internal}
