% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MultiMeta.R
\name{MultiMeta}
\alias{MultiMeta}
\alias{MultiMeta,}
\alias{multimeta}
\title{Meta-analysis for multivariate genome-wide association scan}
\usage{
MultiMeta(reslist, outfile = "Multivariate_meta-analysis_results.txt")
}
\arguments{
\item{reslist}{A list where each element is a multivariate GWA result of class "MultiRes".}

\item{outfile}{A string giving the path and file name of the output file. By default, a file
named \code{'Multivariate_meta-analysis_results.txt'} will be written into the current working directory.}
}
\value{
The function returns a matrix containing the meta-analysis results, where the row names are
the variants names, and the column names are the names of the studies provided in \code{reslist} or
generated by the program if no names are given, with an extra column \code{"p.meta"} containing the 
meta-analysis P-values. The results are also written into \code{outfile}.
}
\description{
The function performs meta-analysis for multiple multivariate GWA analyses
}
\examples{
\dontrun{
## loading two gwaa.data sets in GenABEL
data(ge03d2)
data(ge03d2ex)

## in each dataset, running multivariate GWAS for 3 traits: height, weight, bmi
res1 <- Multivariate(gwaa.data = ge03d2, trait.cols = c(5, 6, 8), 
                     covariate.cols = c(2, 3))
res2 <- Multivariate(gwaa.data = ge03d2ex.clean, trait.cols = c(5, 6, 8), 
                     covariate.cols = c(2, 3))

## running meta-analysis by combining the P-values
meta <- MultiMeta(list(res1, res2))
}
}
\references{
Xia Shen, ..., Gordan Lauc, Jim Wilson, Yurii Aulchenko (2014).
Multi-omic-variate analysis identified the association between 14q32.33 and 
compound N-Glycosylation of human Immunoglobulin G \emph{Submitted}.
}
\seealso{
\code{Multivariate}
}
\author{
Xia Shen
}
\keyword{meta-analysis}
\keyword{multivariate,}
