% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/meshPlaneIntersect.r
\name{meshPlaneIntersect}
\alias{meshPlaneIntersect}
\title{get intersections between mesh and a plane}
\usage{
meshPlaneIntersect(mesh, v1, v2, v3)
}
\arguments{
\item{mesh}{triangular mesh of class "mesh3d"}

\item{v1}{numeric vector of length=3 specifying a point on the separating plane}

\item{v2}{numeric vector of length=3 specifying a point on the separating plane}

\item{v3}{numeric vector of length=3 specifying a point on the separating plane}
}
\value{
returns the intersections of edges and the plane
}
\description{
get intersections between mesh and a plane
}
\examples{
data(nose)
v1 <- shortnose.lm[1,]
v2 <- shortnose.lm[2,]
v3 <- shortnose.lm[3,]
intersect <- meshPlaneIntersect(shortnose.mesh,v1,v2,v3)
\dontrun{
require(rgl)
wire3d(shortnose.mesh)
spheres3d(shortnose.lm[1:3,],col=2)#the plane
spheres3d(intersect,col=3,radius = 0.2)#intersections
}
}

