% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grindr-pile.R
\name{pile}
\alias{pile}
\alias{pile.default}
\alias{pile.list}
\alias{pile.array}
\alias{pile.Out}
\alias{pile.Opn}
\alias{pile.Ldk}
\title{Graphical pile of shapes}
\usage{
pile(coo, f, sample, subset, pal, paper_fun, draw_fun, transp, ...)

\method{pile}{default}(coo, f, sample, subset, pal = pal_qual,
  paper_fun = paper, draw_fun = draw_curves, transp = 0, ...)

\method{pile}{list}(coo, f, sample = 64, subset = 1000, pal = pal_qual,
  paper_fun = paper, draw_fun = draw_curves, transp = 0, ...)

\method{pile}{array}(coo, f, sample = 64, subset = 1000, pal = pal_qual,
  paper_fun = paper, draw_fun = draw_landmarks, transp = 0, ...)

\method{pile}{Out}(coo, f, sample = 64, subset = 1000, pal = pal_qual,
  paper_fun = paper, draw_fun = draw_outlines, transp = 0, ...)

\method{pile}{Opn}(coo, f, sample = 64, subset = 1000, pal = pal_qual,
  paper_fun = paper, draw_fun = draw_curves, transp = 0, ...)

\method{pile}{Ldk}(coo, f, sample = 64, subset = 1000, pal = pal_qual,
  paper_fun = paper, draw_fun = draw_landmarks, transp = 0, ...)
}
\arguments{
\item{coo}{a single shape or any  \link{Coo} object}

\item{f}{factor specification}

\item{sample}{\code{numeric} number of points to \link{coo_sample}
if the number of shapes is > 1000 (default: 64).
If non-numeric (eg \code{FALSE}) do not sample.}

\item{subset}{\code{numeric} only draw this number of (randomly chosen) shapes if
the number of shapes is > 1000 (default: 1000) If non-numeric (eg \code{FALSE}) do not sample.}

\item{pal}{palette among \link{palettes} (default: pal_qual)}

\item{paper_fun}{a \link{papers} function (default: \code{paper})}

\item{draw_fun}{one of \link{drawers} for \code{pile.list}}

\item{transp}{\code{numeric} for transparency (default:adjusted, min:0, max=0)}

\item{...}{more arguments to feed the core drawer, depending on the object}
}
\description{
Pile all shapes in the same graphical window. Useful to check
their normalization in terms of size, position, rotation, first point, etc.
It is, essentially, a shortcut around \code{paper + drawers} of the grindr family.
}
\details{
Large \code{Coo} are sampled, both in terms of the number of shapes and of points to drawn.
}
\note{
A variation of this plot was called \code{stack} before \code{Momocs 1.2.5}
}
\examples{
# all Coo are supported with sensible defaults
pile(bot)    # outlines
pile(olea, ~var, pal=pal_qual_Dark2, paper_fun=paper_grid)   # curves
pile(wings)  # landmarks

# you can continue the pipe with compatible drawers
pile(bot, trans=0.9) \%>\% draw_centroid

# if you are not happy with this, build your own !
# eg see Momocs::pile.Out (no quotes)

my_pile <- function(x, col_labels="red", transp=0.5){
    x \%>\% paper_chess(n=100) \%>\%
          draw_landmarks(transp=transp) \%>\%
          draw_labels(col=col_labels)
}
# using it
wings \%>\% my_pile(transp=3/4)

 # and as gridr functions propagate, you can even continue:
 wings \%>\% my_pile() \%>\% draw_centroid(col="blue", cex=5)

 # method on lists
 bot$coo \%>\% pile

 # it can be tuned when we have a list of landmarks with:
 wings$coo \%>\% pile(draw_fun=draw_landmarks)

 # or on arrays (turn for draw_landmarks)
 wings$coo \%>\% l2a \%>\% #we now have an array
     pile
}
\seealso{
Other grindr: \code{\link{drawers}}, \code{\link{layers}},
  \code{\link{mosaic_engine}}, \code{\link{papers}},
  \code{\link{plot_PCA}}
}
