% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/babel-bridges.R
\name{a2l}
\alias{a2l}
\title{Converts an array of coordinates to a list of matrices}
\usage{
a2l(a)
}
\arguments{
\item{a}{\code{array} of coordinates.}
}
\value{
\code{list} with 2-cols matrices of (x; y) coordinates.
}
\description{
Converts a \code{m x n x k} array of coordinates to a list of
\code{k} matrices with \code{m} rows and \code{n} columns matrices.
}
\details{
May be useful to communicate with other morphometrics packages that use
array of coordinates when handling configurations of landmarks.
}
\examples{
data(wings)
l <- wings$coo
l
a <- l2a(l)
a
}
\seealso{
Other bridges functions: \code{\link{a2m}},
  \code{\link{as_df}}, \code{\link{coo2cpx}},
  \code{\link{cpx2coo}}, \code{\link{d2m}},
  \code{\link{l2a}}, \code{\link{l2m}}, \code{\link{m2a}},
  \code{\link{m2d}}, \code{\link{m2ll}}, \code{\link{m2l}}
}
