% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Inference.R
\name{is.root}
\alias{is.root}
\title{Root nodes}
\usage{
is.root(node, dag)
}
\arguments{
\item{node}{A character string indicating the node's name.}

\item{dag}{An object of class \code{"bn"}.}
}
\value{
\code{is.root} returns TRUE or FALSE depending on whether the node is root or not.
}
\description{
\code{is.root} checks whether a node has parents or not.
}
\examples{

## Create a dataset
  # Continuous variables
  x <- rnorm(100)
  y <- rnorm(100)
  
  # Discrete variable
  z <- sample(letters[1:2],size = 100, replace = TRUE)
  
  data <- data.frame(C1 = x, C2 = y, D1 = z, stringsAsFactors = FALSE)
  
## Get DAG
  dag <- LearningHC(data)
  
## Check if a node is root
 is.root("C1", dag)
}
