% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/3_coreFunctions.R
\name{createAlgorithm}
\alias{createAlgorithm}
\title{createAlgorithm}
\usage{
createAlgorithm(
  state,
  effects,
  multinomialProposal = FALSE,
  burnInN1 = NULL,
  thinningN1 = NULL,
  iterationsN1 = NULL,
  gainN1 = 0.1,
  burnInN2 = NULL,
  thinningN2 = NULL,
  initialIterationsN2 = 50,
  nsubN2 = 4,
  initGain = 0.6,
  burnInN3 = NULL,
  thinningN3 = NULL,
  iterationsN3 = 500,
  allowLoops = NULL
)
}
\arguments{
\item{state}{An object of class "processState.monan" that contains all relevant information about
the outcome in the form of an edgelist, the nodesets, and covariates.}

\item{effects}{An object of class "effectsList.monan" that specifies the model.}

\item{multinomialProposal}{How should the next possible outcome in the simulation chains
be sampled? If TRUE, fewer simulation steps are needed, but each simulation
step takes considerably longer. Defaults to FALSE.}

\item{burnInN1}{The number of simulation steps before the first draw in Phase 1.
A recommended value is at least n_Individuals * n_locations if
multinomialProposal = FALSE, and at least n_Individuals if multinomialProposal = TRUE
which is set as default.}

\item{thinningN1}{The number of simulation steps between two draws in Phase 1.
A recommended value is at least 0.5 * n_Individuals * n_locations if
multinomialProposal = FALSE, and at least n_Individuals if multinomialProposal = TRUE
which is set as default.}

\item{iterationsN1}{The number of draws taken in Phase 1.
A recommended value is at least 4 * n_effects which is set as default.
If the value is too low, there will be an error in Phase 1.}

\item{gainN1}{The size of the updating step after Phase 1. A conservative
value is 0, values higher than 0.25 are courageous. Defaults to 0.1.}

\item{burnInN2}{The number of simulation steps before the first draw in Phase 1.
A recommended value is at least n_Individuals * n_locations if
multinomialProposal = FALSE, and at least n_Individuals if multinomialProposal = TRUE
which is set as default.}

\item{thinningN2}{The number of simulation steps between two draws in Phase 2.
A recommended value is at least 0.5 * n_Individuals * n_locations if
multinomialProposal = FALSE, and at least n_Individuals if multinomialProposal = TRUE
which is set as default.}

\item{initialIterationsN2}{The number of draws taken in subphase 1 of Phase 2.
For first estimations, a recommended value is around 50 (default to 50).
Note that in later subphases, the number of iterations increases.
If this is a further estimation to improve convergence, higher values (100+)
are recommended.}

\item{nsubN2}{Number of subphases in Phase 2. In case this is the first
estimation, 4 subphases are recommended and set as default. If convergence
in a previous estimation was close, then 1-2 subphases should be enough.}

\item{initGain}{The magnitude of parameter updates in the first subphase of
Phase 2. Values of around 0.2 (default) are recommended.}

\item{burnInN3}{The number of simulation steps before the first draw in Phase 3.
A recommended value is at least 3 * n_Individuals * n_locations if
multinomialProposal = FALSE, and at least 3 * n_Individuals if multinomialProposal = TRUE
which is set as default.}

\item{thinningN3}{The number of simulation steps between two draws in Phase 3.
A recommended value is at least n_Individuals * n_locations if
multinomialProposal = FALSE, and at least 2 * n_Individuals if multinomialProposal = TRUE
which is set as default.
In case this value is too low, the outcome might erroneously indicate a lack
of convergence.}

\item{iterationsN3}{Number of draws in Phase 3. Recommended are at the very
least 500 (default).
In case this value is too low, the outcome might erroneously indicate a lack
of convergence.}

\item{allowLoops}{Logical: can individuals/resources stay in their origin?}
}
\value{
An object of class "algorithm.monan".
}
\description{
Specifies the algorithm used in the estimation based on characteristics
of the state and the effects.
}
\examples{
# define algorithm based on state and effects characteristics
myAlg <- createAlgorithm(myState, myEffects, multinomialProposal = FALSE)
}
\seealso{
\code{\link[=createProcessState]{createProcessState()}}, \code{\link[=createEffectsObject]{createEffectsObject()}}, \code{\link[=estimateMobilityNetwork]{estimateMobilityNetwork()}}
}
