% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsearch.R
\name{vs_search_global}
\alias{vs_search_global}
\title{Search for a list of sequence in a fasta file against physeq reference
sequences using \href{https://github.com/torognes/vsearch}{vsearch}}
\usage{
vs_search_global(
  physeq,
  path_to_fasta = NULL,
  seq2search = NULL,
  vsearchpath = "vsearch",
  id = 0.8,
  iddef = 0,
  keep_temporary_files = FALSE
)
}
\arguments{
\item{physeq}{(required): a \code{\link[phyloseq]{phyloseq-class}} object obtained
using the \code{phyloseq} package.}

\item{path_to_fasta}{(required if seq2search is NULL) a path to fasta file if seq2search is est to NULL.}

\item{seq2search}{(required if path_to_fasta is NULL) Either (i) a DNAstringSet object
or (ii) a character vector that will be convert to DNAstringSet using
\code{\link[Biostrings:XStringSet-class]{Biostrings::DNAStringSet()}}}

\item{vsearchpath}{(default: "vsearch") path to vsearch}

\item{id}{(default: 0.8) id for the option \code{--usearch_global} of the vsearch software}

\item{iddef}{(default: 0) iddef for the option \code{--usearch_global} of the vsearch software}

\item{keep_temporary_files}{(logical, default: FALSE) Do we keep temporary files
\itemize{
\item temp.fasta (refseq in fasta)
\item cluster.fasta (centroid)
\item temp.uc (clusters)
}}
}
\value{
A dataframe with uc results (invisible)
}
\description{
\if{html}{\out{
<a href="https://adrientaudiere.github.io/MiscMetabar/articles/Rules.html#lifecycle">
<img src="https://img.shields.io/badge/lifecycle-maturing-blue" alt="lifecycle-maturing"></a>
}}


Use of VSEARCH software.
}
\details{
This function is mainly a wrapper of the work of others.
Please cite \href{https://github.com/torognes/vsearch}{vsearch}.
}
\examples{
\dontshow{if (MiscMetabar::is_vsearch_installed()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
if (requireNamespace("seqinr")) {
  file_dna <- tempfile("dna.fa")
  seqinr::write.fasta("GCCCATTAGTATTCTAGTGGGCATGCCTGTTCGAGCGTCATTTTCAACC",
    file = file_dna, names = "seq1"
  )

  res <- vs_search_global(data_fungi, path_to_fasta = file_dna)
  unlink(file_dna)

  res[res$identity != "*", ]

  clean_pq(subset_taxa(data_fungi, res$identity != "*"))
}
}
\dontshow{\}) # examplesIf}
}
\author{
Adrien Taudière
}
