% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predictors_functions.R
\name{multi_hist}
\alias{multi_hist}
\title{multi_hist}
\usage{
multi_hist(dat, color = MiMIR::c21, scaled = FALSE)
}
\arguments{
\item{dat}{data.frame or matrix with the variables to plot}

\item{color}{colors selected for all the variables}

\item{scaled}{logical to z-scale the variables}
}
\value{
plotly image with the histograms for all the variables in dat
}
\description{
#' Function to plot the histograms for all the variables in dat
}
\examples{
\donttest{
library(plotly)
library(MiMIR)

#load the dataset
metabolic_measures <- synthetic_metabolic_dataset

multi_hist(metabolic_measures[,MiMIR::metabolites_subsets$MET14], scaled=T)
}

}
