% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regression.R
\name{percent_bias}
\alias{percent_bias}
\title{Percent Bias}
\usage{
percent_bias(actual, predicted)
}
\arguments{
\item{actual}{The ground truth numeric vector.}

\item{predicted}{The predicted numeric vector, where each element in the vector
is a prediction for the corresponding element in \code{actual}.}
}
\description{
\code{percent_bias} computes the average amount that \code{actual} is greater
than \code{predicted} as a percentage of \code{actual}.
}
\details{
If a model is unbiased \code{percent_bias(actual, predicted)} should be close
to zero. Percent Bias is calculated by taking the average of
(\code{actual} - \code{predicted}) / \code{actual}.

\code{percent_bias} will give \code{-Inf}, \code{Inf}, or \code{NaN}, if any
elements of \code{actual} are \code{0}.
}
\examples{
actual <- c(1.1, 1.9, 3.0, 4.4, 5.0, 5.6)
predicted <- c(0.9, 1.8, 2.5, 4.5, 5.0, 6.2)
percent_bias(actual, predicted)
}
\seealso{
\code{\link{bias}}
}
